<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Dragonbyte Technologies Advanced Post Thanks & Like Pro 1.1.9    # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/


/**
* Postbit optimized for posts with no content - requires thanks
*/
class vB_Postbit_Thanks extends vB_Postbit_Post
{
	/**
	* May not be displayed.
	*/
	function process_attachments()
	{
		global $show, $vbphrase;
		
		$override = '';
		
		if ($this->post['attachments'])
		{
			if ($this->post['dbtech_thanks_requiredbuttons_attach'])
			{
				foreach (THANKS::$cache['button'] as $button)
				{
					if (!$button['active'])
					{
						// Inactive button
						continue;
					}
					
					if (!$button['active'])
					{
						// Inactive button
						continue;
					}
					
					if (((int)$this->post['dbtech_thanks_requiredbuttons_attach'] & (int)$button['bitfield']) AND 
						$this->post['userid'] != $this->registry->userinfo['userid'] AND 
						!THANKS::$entrycache["{$this->post[postid]}"]["$button[varname]"]['data']["{$this->registry->userinfo[userid]}"]
					)
					{
						// Override message on the attach field
						$override .= '<li>' . construct_phrase($vbphrase['dbtech_thanks_require_x_attach'], $button['title']) . '</li>';
					}
				}
			}
		}
		
		if ($override)
		{
			// We require thanks
			$show['attachments'] = true;
			$show['otherattachment'] = true;
			$this->post['otherattachments'] = $override;
		}
		else
		{
			parent::process_attachments();
		}		
	}
	
	/**
	* Override message
	*/
	function parse_bbcode()
	{
		global $vbphrase;
		
		if (!defined('IN_MOBIQUO') AND !defined('IN_FRNR'))
		{
			if (!$this->post['message'])
			{
				// Weird ass workaround
				$this->post['message'] =& $this->post['pagetext'];
			}
		}
					
		$override = array();
		if ($this->post['dbtech_thanks_requiredbuttons_content'])
		{
			foreach (THANKS::$cache['button'] as $button)
			{
				if (!$button['active'])
				{
					// Inactive button
					continue;
				}
				
				if (!$button['active'])
				{
					// Inactive button
					continue;
				}
				
				if (($this->post['dbtech_thanks_requiredbuttons_content'] & (int)$button['bitfield']) AND 
					$this->post['userid'] != $this->registry->userinfo['userid'] AND 
					!THANKS::$entrycache["{$this->post[postid]}"]["$button[varname]"]['data']["{$this->registry->userinfo[userid]}"]
				)
				{
					// Override message on the attach field
					$override[] = construct_phrase($vbphrase['dbtech_thanks_require_x_post'], $button['title']);
				}
			}
		}
		
		// Ensure this works as intended
		$override = implode('<br />', $override);		
		
		if (!THANKS::$isPro)
		{					
			if ($override)
			{
				// We require something
				$this->post['message'] = $override;
			}
			else
			{
				// Just parse BBCode normally
				parent::parse_bbcode();
			}
		}
		else
		{
			// Should really be an option around this methinks
			unset($this->post['pagetext_html']);				
					
			// We may or may not require something
			THANKS::parse_bbcode($this->post['message'], ($override ? $override : '$1'));
			
			// Also parse standard BBCode
			parent::parse_bbcode();
		}
	}
}

/**
* Postbit optimized for downranked posts
*/
class vB_Postbit_Thanks_Downranked extends vB_Postbit_Post
{
	/**
	* The name of the template that will be used to display this post.
	*
	* @var	string
	*/
	var $templatename = 'dbtech_thanks_postbit_downranked';

	/**
	* Will not be displayed. No longer does anything.
	*/
	function process_attachments()
	{
	}

	/**
	* Will not be displayed. No longer does anything.
	*/
	function process_im_icons()
	{
	}

	/**
	* Will not be displayed. No longer does anything.
	*/
	function parse_bbcode()
	{
	}
}
?>